/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.entities;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;

public class PipeFrameEntity
extends ItemFrame
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> AMOUNT = SynchedEntityData.m_135353_(PipeFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PipeFrameEntity(EntityType<PipeFrameEntity> type, Level world) {
        super(type, world);
    }

    public PipeFrameEntity(EntityType<PipeFrameEntity> type, Level world, BlockPos pos, Direction dir) {
        this(type, world);
        this.f_31698_ = pos;
        this.m_6022_(dir);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AMOUNT, (Object)-1);
    }

    public void m_8119_() {
        ItemStack stack;
        BlockPos node;
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.f_19797_ % 40 != 0) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(this.f_19853_);
        BlockPos attached = PipeFrameEntity.getAttachedPipe(this.f_19853_, this.f_31698_, this.f_31699_);
        if (attached != null && (node = network.getNodeFromPipe(attached)) != null && !(stack = this.m_31822_()).m_41619_()) {
            List<NetworkLocation> items = network.getOrderedNetworkItems(node);
            int amount = items.stream().mapToInt(i -> i.getItemAmount(this.f_19853_, stack, new ItemEquality[0])).sum();
            this.f_19804_.m_135381_(AMOUNT, (Object)amount);
            return;
        }
        this.f_19804_.m_135381_(AMOUNT, (Object)-1);
    }

    public boolean m_7088_() {
        return super.m_7088_() && PipeFrameEntity.canPlace(this.f_19853_, this.f_31698_, this.f_31699_);
    }

    private static BlockPos getAttachedPipe(Level world, BlockPos pos, Direction direction) {
        for (int i = 1; i <= 2; ++i) {
            BlockPos offset = pos.m_5484_(direction.m_122424_(), i);
            BlockState state = world.m_8055_(offset);
            if (!(state.m_60734_() instanceof PipeBlock)) continue;
            return offset;
        }
        return null;
    }

    public static boolean canPlace(Level world, BlockPos pos, Direction direction) {
        return PipeFrameEntity.getAttachedPipe(world, pos, direction) != null;
    }

    public int getAmount() {
        return (Integer)this.f_19804_.m_135370_(AMOUNT);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!source.m_19372_() && !this.m_31822_().m_41619_()) {
            if (!this.f_19853_.f_46443_) {
                this.dropItemOrSelf(source.m_7640_(), false);
                this.m_5496_(SoundEvents.f_12016_, 1.0f, 1.0f);
            }
            return true;
        }
        return super.m_6469_(source, amount);
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        this.m_5496_(SoundEvents.f_12014_, 1.0f, 1.0f);
        this.dropItemOrSelf(brokenEntity, true);
    }

    private void dropItemOrSelf(@Nullable Entity entityIn, boolean b) {
        if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            if (entityIn == null) {
                this.m_31822_().m_41636_(null);
            }
        } else {
            Player playerentity;
            ItemStack itemstack = this.m_31822_();
            this.m_31805_(ItemStack.f_41583_);
            if (entityIn instanceof Player && (playerentity = (Player)entityIn).m_7500_()) {
                itemstack.m_41636_(null);
                return;
            }
            if (b) {
                this.m_19998_((ItemLike)Registry.pipeFrameItem);
            }
            if (!itemstack.m_41619_()) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41636_(null);
                this.m_19983_(itemstack);
            }
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_31822_().m_41619_()) {
            return super.m_6096_(player, hand);
        }
        return InteractionResult.FAIL;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)Registry.pipeFrameItem);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.f_31698_);
        buffer.writeInt(this.f_31699_.ordinal());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.f_31698_ = additionalData.m_130135_();
        this.f_31699_ = Direction.values()[additionalData.readInt()];
    }
}

